/*
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: bdial.c,v 1.1.1.1 2004/03/11 03:59:32 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>

#include <stdio.h>
#include <string.h>

#define CONTROL_PATH	"/tmp/.bab_control"

static void error(const char *huh)
{
	perror(huh);
	exit(1);
}

int parse_in(const char *s, int *retp)
{
	int status, i=0;
	unsigned int callid;

	sscanf(s, "[%u] %d:%n", &callid, &status, &i);
	if (s[i])
		i++;

	if (!status) {
		printf("%s\n", s+i);
		fflush(stdout);
	} else if (status == -1) {
		if (s[i])
			printf("%s\n", s+i);
		*retp = 0;
		return 1;
	} else if (status < -1) {
		if (s[i])
			printf("Failed: %s\n", s+i);
		*retp = (1);
		return 1;
	} else {
		printf("Failed with cause 0x%02x: %s\n", status, s+i);
		*retp = 1;
		return 1;
	}
	return 0;
}

int s_copy(int dest_fd, int s_fd, fd_set *fds, int *retp)
{
	static char current_line[4096];
	static unsigned current_pos;
	int ret = 0;

	if (FD_ISSET(s_fd, fds)) {
		char *bp;
		int len, i, begin;
		bp = current_line + current_pos;
		len = read(s_fd, bp, sizeof(current_line) - current_pos - 1);
		if (len < 0)
			error("read");
		if (len == 0) {
fprintf(stderr, "[quit -- read]\n");
			*retp = 0;
			return 1;
		}

		current_pos += len;

		begin = 0;
		for (i=0; i<current_pos; i++) {
			if ('\n' == current_line[i]) {
				current_line[i] = 0;
				ret |= parse_in(current_line + begin, retp);
				begin = i+1;
			}
		}

		current_pos = current_pos - begin;
		if (begin && current_pos) {
			for (i=0; i<current_pos; i++)
				current_line[i] = current_line[i+begin];
		}
	}

	return ret;
}

int main(int argc, char *argv[])
{
	struct sockaddr_un addr;
	fd_set rfds;
	int fd, i;
	char *p;
	int repeats = 0, skip_arg1 = 0;
	int ret = 0;

	if (argc > 1 && !strncmp(argv[1], "--repeat=", 9)) {
		skip_arg1 = 1;
		repeats = atoi(argv[1] + 9);
		fprintf(stderr, "repeats: %d\n", repeats);
	}

	p = strrchr(argv[0], '/');
	if (p)
		argv[0] = p+1;

again:
	fd = socket(AF_UNIX, SOCK_STREAM, 0);
	if (-1 == fd)
		error("socket");
	addr.sun_family = AF_UNIX;
	strcpy(addr.sun_path, CONTROL_PATH);
	if (-1 == connect(fd, (struct sockaddr *)&addr, sizeof(addr.sun_family)+strlen(addr.sun_path)))
		error("Unable to connect to server(" CONTROL_PATH ")");

	for (i=0; i<argc; i++) {
		int pos = 0, len = strlen(argv[i]);

		if (i == 1 && skip_arg1)
			continue;

		if (i && write(fd, " ", 1) <= 0)
			error("write[' ']");

		while (len > 0) {
			int ret = write(fd, argv[i] + pos, len);
			if (ret < 0)
				error("write[main]");
			len -= ret;
			pos += ret;
		}
	}

	if (i && write(fd, "\n", 1) <= 0)
		error("write['\n']");

	FD_ZERO(&rfds);

	for (;;) {
		/*FD_SET(0, &rfds);*/
		FD_SET(fd, &rfds);
		if (-1 == select(fd+1, &rfds, NULL, NULL, NULL))
			error("select");

		if (s_copy(0, fd, &rfds, &ret))
			break;
		if (s_copy(fd, 0, &rfds, &ret))
			break;
	}

	close(fd);

	if (--repeats > 0)
		goto again;

	return ret;
}

