/*
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: simple_bundle.c,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#include "aps_if.h"

int main ( int argc, char *argv[] )
{
	int fd, len, num;

	printf("Opening...\n");

	fd = open(argv[1], O_RDWR | (argc == 3 ? O_NONBLOCK : 0));
	if (-1 == fd) {
		fprintf(stderr, "Error opening %s: %s\n", argv[1], strerror(errno));
		return 1;
	}

	if (argc == 3) {
		int fl = fcntl(fd, F_GETFL, 0);
		fl &= ~O_NONBLOCK;
		fcntl(fd, F_SETFL, fl);

		printf("Dialing %s...\n", argv[2]);
		if ((len = ioctl(fd, BIOCDIAL, argv[2])) < 0) {
			perror("Dial failed:");
			return 1;
		}

		if (len > 0) {
			fprintf(stderr, "Dial failed cause 0x%02x\n", len);
			return 1;
		}
	}

	printf("Waiting for packets...\n");

	num = -1;
	if (0 != ioctl(fd, BIOCCREATEBUNDLE, &num))
		perror("create bundle");
	printf("created device aps%d\n", num);

	if (0 != ioctl(fd, BIOCJOINBUNDLE, 0/*num*/))
		perror("join bundle");
	printf("joined bundle.\n");
	if (0 != ioctl(fd, BIOC_SETBFL, 0x11))
		perror("setbfl(0x11)");
	if (0 != ioctl(fd, BIOC_SETCFL, 0x11))
		perror("setcfl(0x11)");
	printf("flags set.\n");

	getchar();

	if (0 != ioctl(fd, BIOC_SETCFL, 0x00))
		perror("setcfl(0x00)");
	printf("leaving bundle...\n");
	if (0 != ioctl(fd, BIOCLEAVEBUNDLE, 0))
		perror("join bundle");

	if (0 != ioctl(fd, BIOCDESTROYBUNDLE, num))
		perror("destroy bundle");
	printf("bundle destroyed.\n");

	return 0;
}

