/*
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: simple_bdial.c,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/time.h>
#include <unistd.h>

#include <stdio.h>
#include <string.h>

#define CONTROL_PATH	"/tmp/bab_control"

static void error(const char *huh)
{
	perror(huh);
	exit(1);
}

void s_copy(int dest_fd, int s_fd, fd_set *fds)
{
	if (FD_ISSET(s_fd, fds)) {
		char buf[256], *bp=buf;
		int len, ret;
		len = read(s_fd, buf, sizeof(buf));
		if (len < 0)
			error("read");
		if (len == 0) {
fprintf(stderr, "[quit -- read]\n");
			exit(0);
		}

		while (len > 0) {
			ret = write(dest_fd, bp, len);
			if (ret < 0)
				error("write");
			if (len == 0) {
fprintf(stderr, "[quit -- write]\n");
				exit(0);
			}

			len -= ret;
		}
	}
}

int main(int argc, char *argv[])
{
	struct sockaddr_un addr;
	fd_set rfds;
	int fd, i;
	char *p;

	p = strrchr(argv[0], '/');
	if (p)
		argv[0] = p+1;

	fd = socket(AF_UNIX, SOCK_STREAM, 0);
	if (-1 == fd)
		error("socket");
	addr.sun_family = AF_UNIX;
	strcpy(addr.sun_path, CONTROL_PATH);
	if (-1 == connect(fd, (struct sockaddr *)&addr, sizeof(addr.sun_family)+strlen(addr.sun_path)))
		error("Unable to connect to server(" CONTROL_PATH ")");

	for (i=0; i<argc; i++) {
		int pos = 0, len = strlen(argv[i]);

		if (i && write(fd, " ", 1) <= 0)
			error("write[' ']");

		while (len > 0) {
			int ret = write(fd, argv[i] + pos, len);
			if (ret < 0)
				error("write[main]");
			len -= ret;
			pos += ret;
		}
	}

	if (i && write(fd, "\n", 1) <= 0)
		error("write['\n']");

	FD_ZERO(&rfds);

	for (;;) {
		FD_SET(0, &rfds);
		FD_SET(fd, &rfds);
		if (-1 == select(fd+1, &rfds, NULL, NULL, NULL))
			error("select");

		s_copy(0, fd, &rfds);
		s_copy(fd, 0, &rfds);
	}
}

