/*
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: setmvip.c,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#include "../include/aps_if.h"

int main ( int argc, char *argv[] )
{
	int fd, stream, slot;

	printf("Opening...\n");

	fd = open(argv[1], O_RDWR | O_NONBLOCK);
	if (-1 == fd) {
		fprintf(stderr, "Error opening %s: %s\n", argv[1], strerror(errno));
		return 1;
	}

	stream = atoi(argv[2]);
	slot = atoi(argv[3]);

	printf("ioctl(%d, BIOC_MVIP_ATTACH, MVIP_SLOT(%d, %d) = %lu ) = %d\n",
		fd, stream, slot, MVIP_SLOT(stream, slot),
		ioctl(fd, BIOC_MVIP_ATTACH, MVIP_SLOT(stream, slot))
		);

	return 0;
}

