/*
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: mkchraw.c,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#include "../include/aps_if.h"

int main ( int argc, char *argv[] )
{
	int fd, i;

	printf("Opening...\n");

	fd = open(argv[1], O_RDWR | O_NONBLOCK);
	if (-1 == fd) {
		fprintf(stderr, "Error opening %s: %s\n", argv[1], strerror(errno));
		return 1;
	}

	if (ioctl(fd, BIOC_GETFRAME, &i)) {
		perror("ioctl(BIOC_GETFRAME)");
		return 1;
	}

	printf("Old frame format: %d\n", i);

	if (argc >= 3) {
		i = atoi(argv[2]);
		printf("Setting new frame format: %d...", i);
		fflush(stdout);
		if (ioctl(fd, BIOC_SETMAXFRAMESIZE, 40)) {
			perror("ioctl(BIOC_SETMAXFRAMESIZE)");
			return 1;
		}
		if (ioctl(fd, BIOC_SETFRAME, i)) {
			perror("ioctl(BIOC_SETFRAME)");
			return 1;
		}
		printf("ok.\n");
	}

	return 0;
}

