/*
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: ktester.c,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>

#include "aps_if.h"

int main ( int argc, char *argv[] )
{
	int fd, ret, num;

	fd = open("/dev/bab/0", O_RDWR | O_NONBLOCK);
	if (fd < 0) {
		perror("open /dev/bab/0");
		exit(1);
	}

	num = -1;
	ret = ioctl(fd, BIOCCREATEBUNDLE, &num);
	if (-1 == ret)
		perror("create");
	printf("create bundle: %d, num=%d\n", ret, num);

	ret = ioctl(fd, BIOCJOINBUNDLE, 0);
	if (-1 == ret)
		perror("join");
	printf("join 0: %d\n", ret);

	ret = ioctl(fd, BIOCLEAVEBUNDLE, 0);
	if (-1 == ret)
		perror("leave");
	printf("leave 0: %d\n", ret);

	ret = ioctl(fd, BIOCDESTROYBUNDLE, num);
	if (-1 == ret)
		perror("destroy");
	printf("delete bundle: %d\n", ret);
	return 0;
}

