/*
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: hangup.c,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#include "../include/aps_if.h"

int open_dev(const char *name)
{
	int fd = open(name, O_RDWR | O_NONBLOCK);

	if (-1 == fd && ENOENT == errno) {
		char buf[256];
		strcpy(buf, "/dev/");
		strncpy(buf, name, 255);
		buf[255] = 0;
		fd = open(name, O_RDWR | O_NONBLOCK);
	}

	if (-1 == fd)
		fprintf(stderr, "Error opening %s: %s\n", name, strerror(errno));

	return fd;
}

int main ( int argc, char *argv[] )
{
	int fd, i;

	if (argc < 2) {
		fprintf(stderr, "Usage: %s <devices>\n  -- Sends a hangup ioctl to the specified device.\n", argv[0]);
		return 2;
	}

	for (i=1; i<argc; i++) {
		fd = open_dev(argv[i]);
		if (-1 != fd && ioctl(fd, BIOCHANGUP, 0)) {
			fprintf(stderr, "%s: ioctl(BIOCHANGUP): %s", argv[i], strerror(errno));
			return 1;
		}
	}

	return 0;
}

