/*
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: dumppkt.c,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#include "../drivers/scb/scioc.h"

static inline char tohex(unsigned char foo)
{
	if (foo >= 10)
		return 'a' + foo - 0xa;
	return foo + '0';
}

int main ( int argc, char *argv[] )
{
	unsigned char buf[4096];
	char line[80];
	int fd, len;

	printf("Opening...\n");

	fd = open(argv[1], O_RDWR | (argc == 3 ? O_NONBLOCK : 0));
	if (-1 == fd) {
		fprintf(stderr, "Error opening %s: %s\n", argv[1], strerror(errno));
		return 1;
	}

	if (argc == 3) {
		int fl = fcntl(fd, F_GETFL, 0);
		fl &= ~O_NONBLOCK;
		fcntl(fd, F_SETFL, fl);

		printf("Dialing %s...\n", argv[2]);
		if ((len = ioctl(fd, SCIOCDIAL, argv[2])) < 0) {
			perror("Dial failed:");
			return 1;
		}

		if (len > 0) {
			fprintf(stderr, "Dial failed cause 0x%02x\n", len);
			return 1;
		}
	}
#if 0
	write(fd, "\02\01\0177", 3);
#endif
	printf("Waiting for packets...\n");

	memset(line, ' ', sizeof(line));

	for (;;) {
		fd_set rfds;
		int i, x;

		FD_ZERO(&rfds);
		FD_SET(fd, &rfds);

		select(fd+1, &rfds, NULL, NULL, NULL);

		if (0 > (len = read(fd, buf, sizeof(buf))))
			break;

		printf("Packet len: %d = 0x%x\n\n", len, len);

		for (x=i=0; i<len; i++) {
			if (!x) {
				line[x++] = tohex((i >> 12) & 0xf);
				line[x++] = tohex((i >> 8) & 0xf);
				line[x++] = tohex((i >> 4) & 0xf);
				line[x++] = tohex(i & 0xf);
				line[x++] = ':';
				x++;
			}

			line[x++] = tohex(buf[i] >> 4);
			line[x++] = tohex(buf[i] & 0xf);

			if (3 == (i % 4))
				x++;

			line[(i % 16) + 48] = isprint(buf[i]) ? buf[i] : '.';

			if (15 == (i % 16)) {
				line[16 + 48] = 0;
				puts(line);
				x = 0;
			}
		}

		if (i % 16) {
			line[48 + (i % 16)] = 0;
			for (; i % 16; i++) {
				line[x++] = ' ';
				line[x++] = ' ';

				if (3 == (i % 4))
					x++;
			}
			puts(line);
		}

		putchar('\n');
#if 0
	write(fd, "\02\01\0177", 3);
#endif
	*(long *)buf = !*(long *)buf;
#if 0
	write(fd, buf, len);
#endif
	}

	if (len)
		perror("read");

	return 0;
}

