/*
 * program for deleting bundles
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: delbundle.c,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#include "aps_if.h"

int main ( int argc, char *argv[] )
{
	int iface, fd;

	if (argc != 2) {
		fprintf(stderr, "Usage: %s <interface number>\n", argv[0]);
		exit(1);
	}

	iface = atoi(argv[1]);

	fd = open("/dev/bab/0", O_RDWR | O_NONBLOCK);
	if (-1 == fd) {
		fprintf(stderr, "Error opening %s: %s\n", argv[2], strerror(errno));
		exit(1);
	}
	if (0 != ioctl(fd, BIOCDESTROYBUNDLE, iface)) {
		perror("create bundle");
		exit(1);
	}

	return 0;
}

