/*
 * usca.h - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: usca.h,v 1.3 2004/08/16 01:31:41 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef USCA_H
#define USCA_H

#include "config.h"
#include "kernel.h"
#include "debug.h"

#define USCA_BLOCKSIZE	128

class CuscArray  : public CDebugBase
{
private:
	u8	m_buf[USCA_BLOCKSIZE];
public:
        void Print();
	void Put(CuscArray *);
	void Put(u8 *, uint);
	void Put(char *);
	void Put32(u32);
	void Put16(u16);
	void Put8(u8);
	void Chop(uint);
	void Trim(uint);
	void Push32(u32);
	void Push16(u16);
	void Push8(u8);
	u32 Pull32();
	u16 Pull16();
	u8 Pull8();
	bool operator ==(const u8*);
	bool operator ==(CuscArray &);
	void Clear();
	void Pull(CuscArray *, uint);
	int Pull(u8 *, uint);
#if 0
	operator unsigned char * () { return m_start; };
	operator const u16* () { return (u16 *) m_start; };
#endif
	int Push(CuscArray &);
	int Push(const char *);
	int Push(const u8*, uint);
	int Reserve(size_t);
	uint GetLength() { return m_length; };
	CuscArray(const CuscArray &);
	CuscArray(u8*, uint);
	CuscArray();
	virtual ~CuscArray();
	u8* m_start;

protected:
	int ExpandBuffer(size_t);
	uint m_size;		// Total size of storage block
	u8* m_end;			// Pointer to end of data in block
	uint m_length;		// Length of data in block (end-start)
	u8* m_data;			// Pointer to the storage block
};

#endif // USCA_H
