/*
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: selectops.h,v 1.2 2004/07/20 02:07:42 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */
 
#ifndef SELECTOPS_H
#define SELECTOPS_H

#include <limits.h>

#define BAB_OPEN_MAX	4096

enum SelectEventType { SEL_NONE = 0, SEL_READ = 1, SEL_WRITE = 2, SEL_RW = 3 };

class SelectEventHandler;

extern SelectEventHandler *selectObjs[2][BAB_OPEN_MAX];

class SelectEventHandler {
	int fd_used;
	int scan_all;

public:
	SelectEventHandler();
	virtual ~SelectEventHandler();

	void touch_fd(int fd);

	void SelectAddEvent(int fd, SelectEventType event);
	void SelectSetEvents(int fd, SelectEventType event);
	void SelectRemoveEvent(int fd, SelectEventType event);

public:
	virtual void SelectEvent(int fd, SelectEventType event) { };
};

#endif /* SELECTOPS_H */
