/*
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: radius.h,v 1.3 2004/10/18 00:32:50 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */
 
#ifndef RADIUS_CC
#define RADIUS_CC

#include "queue.h"
#include "timer.h"
#include "usca.h"
#ifndef SELECTOPS_H
#include "selectops.h"
#endif
#include "md5.h"

#include <netinet/in.h>

#define RAD_MAX_PKT_SIZE	2048

enum Radius_Codes {
	RC_ACCESS_REQUEST = 1,
	RC_ACCESS_ACCEPT,
	RC_ACCESS_REJECT,
	RC_ACCOUNTING_REQUEST,
	RC_ACCOUNTING_RESPONSE,

	RC_ACCESS_CHALLENGE = 11,
	RC_STATUS_SERVER,
	RC_STATUS_CLIENT
};

enum Radius_Types {
	RT_USER_NAME = 1,
	RT_USER_PASSWORD,
	RT_CHAP_PASSWORD,
	RT_NAS_IP_ADDRESS,
	RT_NAS_PORT,
	RT_SERVICE_TYPE,
	RT_FRAMED_PROTOCOL,
	RT_FRAMED_IP_ADDRESS,
	RT_FRAMED_IP_NETMASK,
	RT_FRAMED_ROUTING,
	RT_FILTER_ID,
	RT_FRAMED_MTU,
	RT_FRAMED_COMPRESSION,
	RT_LOGIN_IP_HOST,
	RT_LOGIN_SERVICE,
	RT_LOGIN_TCP_PORT,
	RT_unassigned1,
	RT_REPLY_MESSAGE,
	RT_CALLBACK_NUMBER,
	RT_CALLBACK_ID,
	RT_unassigned2,
	RT_FRAMED_ROUTE,
	RT_FRAMED_IPX_NETWORK,
	RT_STATE,
	RT_CLASS,
	RT_VENDOR_SPECIFIC,
	RT_SESSION_TIMEOUT,
	RT_IDLE_TIMEOUT,
	RT_TERMINATION_ACTION,
	RT_CALLED_STATION_ID,
	RT_CALLING_STATION_ID,
	RT_NAS_IDENTIFIER,
	RT_PROXY_STATE,
	RT_LOGIN_LAT_SERVICE,
	RT_LOGIN_LAT_NODE,
	RT_LOGIN_LAT_GROUP,
	RT_FRAMED_APPLETALK_LINK,
	RT_FRAMED_APPLETALK_NETWORK,
	RT_FRAMED_APPLETALK_ZONE,
	RT_ACCT_STATUS_TYPE = 40,
	RT_ACCT_DELAY_TIME,
	RT_ACCT_INPUT_OCTETS,
	RT_ACCT_OUTPUT_OCTETS,
	RT_ACCT_SESSION_ID,
	RT_ACCT_AUTHENTIC,
	RT_ACCT_SESSION_TIME,
	RT_ACCT_INPUT_PACKETS,
	RT_ACCT_OUTPUT_PACKETS,
	RT_ACCT_TERMINATE_CAUSE,
	RT_ACCT_MULTI_SESSION_ID,
	RT_ACCT_LINK_COUNT,
	RT_ACCT_INPUT_GIGAWORDS,
	RT_ACCT_OUTPUT_GIGAWORDS,
	RT_CHAP_CHALLENGE = 60,
	RT_NAS_PORT_TYPE,
	RT_PORT_LIMIT,
	RT_LOGIN_LAT_PORT
};

class RadiusClient;

class RadiusReq : CTimer, public CQueueItem {
private:
	RadiusClient	*m_client;

	CfgMessage_t	m_cfg;

	u8		m_authenticator[16];

	u8		m_ident;
	u8		m_cfg_done;
	u8		m_retrans_count;
	u8		m_have_ident;
	MD5_CTX 	m_md5;

	virtual void TimerExpired(void);

public:
	CuscArray	m_pkt;

	RadiusReq(void);

	void Go(CfgMessage_t);
	void Go(AcctMessage_t *);

	int HaveIdent(void) {
		return m_have_ident;
	}
	void SetIdent(u8 ident);
	void RadiusRsp(CuscArray *);
	void RadiusCallback(void);

	friend void timer_cb(void *);
	//friend RadiusClient::Transmit(RadiusReq &);
};


class RadiusClient : public SelectEventHandler {
private:
#define RADIUSCLIENT_N_REQS	256
	RadiusReq	*m_reqs[RADIUSCLIENT_N_REQS];	/* one request per identifier */
	int		m_sockfd;

	u8		*m_secret;	/* secret used for encrypting passwords */
	int		m_secret_len;

	u8		m_next_ident;
	CQueue		m_queue;

public:
	RadiusClient	*m_next;

	RadiusClient(struct sockaddr_in server);
#if 0
	void newReq(CfgMessage_t &cfgreq) {
		RadiusReq *req = new RadiusReq(cfgreq);

		/* find a free identifier */
		u8 orig = m_ident++;
		while (m_reqs[m_ident] && m_ident != orig)
			;

		req->SetIdent(m_ident);
	}
#endif

	void RemoveReq(RadiusReq *req, u8 ident) {
		if (m_reqs[ident] == req)
			m_reqs[ident] = NULL;
		else
			m_queue.Remove(req);
	}

	void Retrans(RadiusReq *req);
	void QueueReq(RadiusReq *req);
        virtual void SelectEvent(int fd, SelectEventType event);
};

extern void setup_radius(const char *ip, int acct);

#endif
