/*
 * queue.h - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: queue.h,v 1.5 2004/08/17 13:41:34 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */
#ifndef QUEUE_H
#define QUEUE_H

#include "kernel.h"
#include "debug.h"

class CQueueItem;

class CQueue
{
public:
	CQueue(int nodelete = 0);
	~CQueue();

protected:
	CQueueItem *m_head;
	CQueueItem *m_tail;
	unsigned int m_size;
	CQueueItem *m_peekMark;
	int m_nodelete;

public:
	void Remove(CQueueItem *i);
	int Insert(CQueueItem *a);
	int Append(CQueueItem *a);
	CQueueItem *Pop();
	CQueueItem *Pull();
	CQueueItem *Peek();
	CQueueItem *PeekNext();
	CQueueItem *Find(char *);
	CQueueItem *Find(unsigned int);
	inline bool IsEmpty() { return(m_head == NULL && m_tail == NULL ? TRUE : FALSE); };
	inline unsigned int Size() { return m_size; };
};

class CQueueItem
{
protected:
	CQueueItem	*m_next;
	CQueueItem	*m_prev;
	CQueue		*m_q;

public:

	CQueueItem() {
		m_next = m_prev = NULL;
		m_q = NULL;
	}

	~CQueueItem() {
		Unlink();
		return;
	}

	inline void SetQueue(CQueue *q) { m_q = q; }
	inline void SetNext(CQueueItem *qi) { m_next = qi; };
	inline CQueueItem *GetNext() { return m_next; };
	inline void SetPrev(CQueueItem *qi) { m_prev = qi; };
	inline CQueueItem *GetPrev() { return m_prev; };

	friend void CQueue::Remove(CQueueItem *qi);

	inline void Unlink(void) {
		if (m_q)
			m_q->Remove(this);
		m_q = NULL;
	}
};

inline CQueueItem *CQueue::Peek()
{
	DebugEnter("CQueue::Peek()");
	m_peekMark = m_head;
	DebugReturn(m_peekMark);
}

inline CQueueItem *CQueue::PeekNext()
{
	DebugEnter("CQueue::PeekNext()");
	if (m_peekMark) {
		m_peekMark = m_peekMark->GetNext();
		if (m_peekMark)
			DebugReturn(m_peekMark);
	}
	DebugReturn(NULL);
}


#endif

