/*
 * queue.cc - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: queue.cc,v 1.2 2004/08/14 23:23:04 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#include <errno.h>

#include "queue.h"

#undef NULL
#define NULL 0

//
// Create the queue
//
CQueue::CQueue(int nodelete)
{
	DebugEnter("CQueue::CQueue()");

	m_peekMark = m_head = m_tail = NULL;
	m_size = 0;
	m_nodelete = nodelete;

	DebugExit();
}

//
// Destroy the queue by removing all items, freeing the wrappers but
// not the data
//
CQueue::~CQueue()
{
	DebugEnter("CQueue::~CQueue()");

	if (m_nodelete)
		return;

	while(!IsEmpty())
		delete Pop();

	DebugExit();
}

//
// Add an item to the beginning of the queue
//
int CQueue::Insert(CQueueItem *qi)
{
	DebugEnter("CQueue::Insert()");

	qi->SetQueue(this);
	if(m_head)
		m_head->SetPrev(qi);
	qi->SetNext(m_head);
	if(!qi->GetNext())
		m_tail = qi;
	m_head = qi;
	m_size++;

	DebugReturn(0);
}

//
// Add an item to the end of the queue
//
int CQueue::Append(CQueueItem *qi)
{
	DebugEnter("CQueue::Append()");

	qi->SetQueue(this);
	if (m_tail)
		m_tail->SetNext(qi);

	qi->SetPrev(m_tail);
	if(!qi->GetPrev())
		m_head = qi;
	m_tail = qi;
	m_size++;

	DebugReturn(0);
}

//
// Retrieve the last item in the queue and remove
//
CQueueItem *CQueue::Pop()
{
	CQueueItem *qi = m_tail;

	DebugEnter("CQueue::Pop()");

	if (!qi)
		DebugReturn(NULL);

	m_tail = qi->GetPrev();
	if (!m_tail)
		m_head = m_tail;

	Remove(qi);

	DebugReturn(qi);
}

//
// Retrieve the first item in the queue and remove
//
CQueueItem *CQueue::Pull()
{
	CQueueItem *qi = m_head;

	DebugEnter("CQueue::Pull()");

	if (!qi)
		DebugReturn(NULL);

	m_head = qi->GetNext();
	if (!m_head)
		m_tail = m_head;

	Remove(qi);

	DebugReturn(qi);
}


void CQueue::Remove(CQueueItem *qi)
{
	if (qi->m_q != this)
		return;

	if (m_head == qi)
		m_head = qi->m_next;
	if (m_tail == qi)
		m_tail = qi->m_prev;
	if (m_peekMark == qi)
		m_peekMark = qi->m_next;

	if (qi->m_next)
		qi->m_next->m_prev = qi->m_prev;
	if (qi->m_prev)
		qi->m_prev->m_next = qi->m_next;
	qi->m_next = qi->m_prev = NULL;
	qi->m_q = NULL;
}

