/*
 * protocol.h - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: protocol.h,v 1.1.1.1 2004/03/11 03:59:31 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef PROTOCOL_H
#define PROTOCOL_H

#include "kernel.h"
#include "debug.h"
#include "packet.h"

//
//
//
#define PPP_PROTO_IP	0x0021
#define PPP_PROTO_MP	0x003D
#define PPP_PROTO_IPCP	0x8021
#define PPP_PROTO_LCP	0xC021
#define PPP_PROTO_PAP	0xC023
#define PPP_PROTO_LQR	0xC025
#define PPP_PROTO_BACP	0xC02B
#define PPP_PROTO_BAP	0xC02D
#define PPP_PROTO_CHAP	0xC223

class CProtocol : public CDebugBase
{
protected:
	unsigned char m_lastSentIdent;
	unsigned char m_lastRcvdIdent;

	char *m_protocolName;
	u32	m_dropCause;

public:
	virtual void Up() {
		DebugEnter("CProtocol::Up()");
		DebugVoidReturn;
	};
	virtual void Down() {
		DebugEnter("CProtocol::Down()");
		DebugVoidReturn;
	};
	virtual void Open() {
		DebugEnter("CProtocol::Open()");
		DebugVoidReturn;
	};
	virtual void Close(const char * why) {
		DebugEnter("CProtocol::Close()");
		if (why);
		DebugVoidReturn;
	};
	virtual void Input(CPppPacket *p) {
		DebugEnter("CProtocol::Input()");
		p = p;
		DebugVoidReturn;
	};
};

extern void timer_callback(unsigned long);

extern CPppPacket m_ackPkt;
extern CPppPacket m_nakPkt;
extern CPppPacket m_rejPkt;
	
class CTimedProtocol : public CProtocol
{
public:
	CTimedProtocol();
	virtual ~CTimedProtocol();

protected:
	unsigned int m_restartTime;

	CTimer ktimer;
	int installed;

public:
	virtual void TimerExpired() { 
		DebugEnter("CTimedProtocol::TimerExpired");
		DebugVoidReturn;
	};
	friend void timer_callback(unsigned long);

	void EnableTimer();
	void DisableTimer();
};

#endif // TIMER_H
