/*
 * protocol.cc - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: protocol.cc,v 1.1.1.1 2004/03/11 03:59:31 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#include "protocol.h"

CPppPacket m_ackPkt;
CPppPacket m_nakPkt;
CPppPacket m_rejPkt;

/*
 * Timer callback
 * Linux kernel timer callbacks dont run in the context of the
 * module, but the kernel. You cannot access any globals without
 * freezing the system. If you need to reference specific data
 * structures, you must pass them in!!!!!!!!!!!!!!!!!!!!!
 * The function is actually called from the timer interrupt handler
 * so keep this in mind --> No globals and no I/O
 */
void timer_callback(void *data)
{
	CTimedProtocol *p = (CTimedProtocol *)data;

	DebugEnter("timer_callback()");

	p->DisableTimer();
	p->TimerExpired();

	DebugVoidReturn;
}

CTimedProtocol::CTimedProtocol()
{
	DebugEnter("CTimedProtocol::CTimedProtocol()");

	m_lastSentIdent = 0;
	m_lastRcvdIdent = 0;
	m_protocolName = NULL;
	m_dropCause = 0;

	m_restartTime = 3;
	ktimer.SetFunction(timer_callback, this);

	DebugExit();
}

CTimedProtocol::~CTimedProtocol()
{
	DebugEnter("CTimedProtocol::~CTimedProtocol()");
	DisableTimer();
	DebugExit();
}

void CTimedProtocol::EnableTimer()
{
	DebugEnter("CTimedProtocol::EnableTimer()");
	if(!installed) {
		ktimer.Start(100 * m_restartTime);
		installed = TRUE;
	}
	DebugVoidReturn;
}

void CTimedProtocol::DisableTimer()
{
	DebugEnter("CTimedProtocol::DisableTimer()");
	if(installed) {
		ktimer.Stop();
		installed = FALSE;
	}
	DebugVoidReturn;
}
