/*
 * proc.c - /proc file system entries
 *
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: proc.c,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#include <linux/kernel.h>
#include <linux/proc_fs.h>

extern int proc_channel_getinfo(char *, char **, off_t, int, int);
extern int proc_interface_getinfo(char *, char **, off_t, int, int);
extern int proc_mpq_getinfo(char *, char **, off_t, int, int);

struct proc_dir_entry proc_babylon_channels = {
	0, 8, "bab_chan", S_IFREG | S_IRUGO, 1, 0, 0, 
	0, &proc_net_inode_operations, proc_channel_getinfo,
	0, 0, 0, 0
};

struct proc_dir_entry proc_babylon_interfaces = {
	0, 7, "bab_dev", S_IFREG | S_IRUGO, 1, 0, 0, 
	0, &proc_net_inode_operations, proc_interface_getinfo,
	0, 0, 0, 0
};

struct proc_dir_entry proc_babylon_mpq = {
	0, 7, "bab_mpq", S_IFREG | S_IRUGO, 1, 0, 0, 
	0, &proc_net_inode_operations, proc_mpq_getinfo,
	0, 0, 0, 0
};

int proc_init(void)
{
	proc_register_dynamic(&proc_root, &proc_babylon_channels);
	proc_register_dynamic(&proc_root, &proc_babylon_interfaces);
	proc_register_dynamic(&proc_root, &proc_babylon_mpq);
	return 0;
}

void proc_cleanup()
{
	proc_unregister(&proc_root, proc_babylon_mpq.low_ino);
	proc_unregister(&proc_root, proc_babylon_interfaces.low_ino);
	proc_unregister(&proc_root, proc_babylon_channels.low_ino);
}

