/*
 * pap.h - Self explanitory
 *
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: pap.h,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef PAP_H
#define PAP_H

#include "kernel.h"
#include "protocol.h"
#include "packet.h"
#include "config.h"

#define PAP_HEADER_LENGTH	4

#define PAP_CODE_AUTHREQ	1
#define PAP_CODE_AUTHACK	2
#define PAP_CODE_AUTHNAK	3

#define MAX_USER_LEN		32
#define MAX_PASS_LEN		32

#define PAP_RETRIES		4

extern void PapTimeout(unsigned long);
extern void PapGotConfig(void *, OptionSet_t *);

class CLink;

class CPapProtocol : public CTimedProtocol  
{
public:
	virtual void Down();
	virtual void Up();
	void SndAuthReq();
	void SndAuthNak();
	void SndAuthAck();
	void RcvAuthNak(CPppPacket *);
	void RcvAuthAck(CPppPacket *);
	void RcvAuthReq(CPppPacket *);
	virtual void Input(CPppPacket *);
	CPapProtocol();
	virtual ~CPapProtocol();

	friend void PapTimeout(void *);
	friend void PapGotConfig(void *, OptionSet_t *);

	virtual void TimerExpired();

	CTimer m_authTimer;

	CLink *m_parent;

protected:
	uint m_restart_count;
};

#endif // PAP_H




