/*
 * packet.h - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: packet.h,v 1.1.1.1 2004/03/11 03:59:31 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef PACKET_H
#define PACKET_H

#include "kernel.h"
#include "usca.h"
#include "queue.h"

#define PPP_HEADER_LENGTH	2

class CLink;

class CPppPacket : public CuscArray, public CQueueItem
{
public:
  CLink *link;
  CPppPacket() { link = NULL; };
  CPppPacket(CLink *l) { link = l; };
  CPppPacket(u8 *d, unsigned int l) : CuscArray(d, l) { link = NULL; };
  CPppPacket(CPppPacket *p) : CuscArray(p->m_start, p->GetLength()) { link = p->link; };
};

#endif // PACKET_H



