/*
 * link.h - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: link.h,v 1.10 2004/08/15 23:22:03 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef LINK_H
#define LINK_H

#include "debug.h"
#include "packet.h"
#include "config.h"
#include "d_aps_if.h"
#include "lcp.h"
#include "pap.h"
#include "chap.h"
#include "babd.h"
#include "selectops.h"
#include "queue.h"

/*
 * Link Phases
 */
enum Phase {
	PHASE_DEAD,
	PHASE_DISCONNECTING,
	PHASE_DIALING,
	PHASE_CONNECTED,
	PHASE_ESTABLISH,
	PHASE_AUTHENTICATE,
	PHASE_TERMINATE,
	PHASE_NETWORK
};

/*
 * The maximum number of times we susspect a loopback'd
 * connection before terminating
 */
#define MAX_LOOP_COUNT	3

class CInterface;
class CLcpProtocol;

class CLink : public CDebugBase, public SelectEventHandler
{
public:
	CLink(channel_t *ch = NULL);
	virtual ~CLink();

public:
	unsigned m_hard_mru, m_hard_mtu;

	// Link Options
	policy_t m_policy;	/* Link policy options */
	policy_t m_npolicy;	/* Link policy options we're negotiating */
	policy_t m_rpolicy;	/* Link policy negotiated by the remote */
	policy_t m_lpolicy;	/* Link policy negotiated by us */

	// Channel we're bound to
	channel_t *m_channel;

	int	m_hung_up;
	int	m_downPending;

	// Interface we're bound to
	CInterface *m_interface;
	OptionSet_t	ifOptions;

	// Link level protocol objects
	CLcpProtocol m_lcpProto;
	CPapProtocol m_papProto;
	CChapProtocol m_chapProto;

	u8 m_wereAcked;
	u8 m_peerAcked;

	// State registers and counters
	enum Phase m_phase;
	int m_loop_count;
	u32 m_ident;

	// Next link is the global list of links
	CLink *m_next;
	CLink **m_prevp;

	// Next link in the bundle we belong to
	CLink *m_nextBundled;

	// Unique link descriptor
	u16 m_ldisc;

	// ConnectComplete() sets the status for the link going down
	int m_lastStatus;

	// State transition members
	virtual void Close(int status, const char *response);
	virtual void Open();
	virtual void Down();
	virtual void Up();
	virtual void ConnectComplete(int);

	void Ready();
	friend int Hangup(char *, int);

	// Link data processing
	int Output(CPppPacket *);
	void Input(u8 *, int);
	virtual int HardOutput(CPppPacket *);
	virtual int JoinBundle(int ndev_id);
	virtual int ch_ioctl(unsigned int cmd, unsigned long arg);
	
	virtual void Hangup(void);
	virtual void HardHangup(void);
	int Connect(const char *num, u32 calltype);
	virtual int HardConnect(const char *num, u32 calltype);

	virtual void GetConfig(void (*cbf)(void *, OptionSet_t *), void *obj, OptionSet_t *options);

	// Accounting data
	unsigned int octets_in;
	unsigned int octets_out;
	unsigned int packets_in;
	unsigned int packets_out;

	/* Reason for shutdown */
	char *m_reason;

	int disc_chans_index;

	TimeVal m_lastouttime;

	int reopen(int answer);
	void chclose(void);
	virtual void SelectEvent(int fd, SelectEventType event);
};

extern CLink *linkListHead;

#ifndef IFACE_H
#include "iface.h"
#endif

#endif // LINK_H
