/*
 * lcp.h - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: lcp.h,v 1.2 2004/07/20 02:09:55 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef LCP_H
#define LCP_H

#include "config.h"
#include "debug.h"
#include "fsm.h"
#include "protocol.h"
#include "packet.h"

class CLink;

#define LCP_HEADER_LENGTH	4

// Packet Codes
#define LCP_CODE_CONFREQ	1
#define LCP_CODE_CONFACK	2
#define LCP_CODE_CONFNAK	3
#define LCP_CODE_CONFREJ	4
#define LCP_CODE_TERMREQ	5
#define LCP_CODE_TERMACK	6
#define LCP_CODE_CODEREJ	7
#define LCP_CODE_PROTOREJ	8
#define LCP_CODE_ECHOREQ	9
#define LCP_CODE_ECHORPLY	10
#define LCP_CODE_DISCREQ	11

// Options Types
#define LCP_OPT_MRU		1
#define LCP_OPT_AUTH		3
#define LCP_OPT_AUTH_CHAP	LCP_OPT_AUTH
#define LCP_OPT_AUTH_PAP	LCP_OPT_AUTH
#define LCP_OPT_QUAL		4
#define LCP_OPT_MAGIC		5
#define LCP_OPT_PFC		7
#define LCP_OPT_ACFC		8

#define LCP_OPT_ACCM		2

#define LCP_OPT_MRRU		17	// MP Max-Receive-Recon-Unit
#define LCP_OPT_SSN		18	// MP Short Sequence Number
#define LCP_OPT_EPD		19	// Multilink End-point Discriptor

#define LCP_OPT_LDISC		23	// Link Discriminator

// Option value constraints
#define LCP_OPT_MRU_MIN		48
#define LCP_OPT_CHAP_MD5	5
#define LCP_OPT_CHAP_RAS	0x80

// Option Defaults
#define LCP_OPT_MRU_DEFAULT	1500
#define LCP_OPT_CHAP_DEFAULT	LCP_OPT_CHAP_MD5

// Option Lengths
#define LCP_OPT_MRU_LEN		4
#define LCP_OPT_PAP_LEN		4
#define LCP_OPT_CHAP_LEN	5
#define LCP_OPT_PFC_LEN		2
#define LCP_OPT_MAGIC_LEN	6
#define LCP_OPT_ACCM_LEN	6
#define LCP_OPT_ACFC_LEN	2
#define LCP_OPT_MRRU_LEN	4
#define LCP_OPT_SSN_LEN		2
#define LCP_OPT_EPD_LEN		3	/* Minimum */
#define LCP_OPT_EPD_ADDR_LEN	20	/* Maximum */
#define LCP_OPT_LDISC_LEN	4

class CLcpProtocol : public CFsmProtocol, public CQueueItem
{
public:
	CLcpProtocol();
	virtual ~CLcpProtocol();

public:
	// External Events
	void Input(CPppPacket *);
	void RejectProtocol(CPppPacket *);

	void EchoTimeout(void);
	void SndEchoReq(void);

	CLink	*m_parent;

private:
	CTimer	m_echoTimer;
	int	m_echoTime;
	u16	m_lastEchoIdent;/* identifier of the last echo request sent */
	u16	m_echoSent;	/* count of echo reqs sent since last reply */
	int	m_rxPackets;

protected:
	virtual void RcvProtoReject(CPppPacket *);
	virtual void RcvCodeReject(CPppPacket *);

	// State Machine triggered events
	virtual void SndEchoReply(CPppPacket *);
	virtual void SndCodeReject(CPppPacket *);
	virtual void ThisLayerDown();
	virtual void ThisLayerUp();
	virtual void ThisLayerFinished(const char *why);
	virtual void SndTermReq();
	virtual void SndConfReq();
	virtual void SndTermAck();
	virtual void SndConfAck();
	virtual void SndConfNak();

	// Configuration Functions
	virtual void RcvConfAck(CPppPacket *);
	virtual void RcvConfRej(CPppPacket *);
	virtual void RcvConfNak(CPppPacket *);
	virtual void RcvConfReq(CPppPacket *);
};

#endif // LCP_H
