#ifndef L2TPD_H
#define L2TPD_H

#include "babd.h"
#include "config.h"
#include "selectops.h"
#include "ctrlfd.h"

#include <netinet/in.h>

extern unsigned num_est_sessions;
extern unsigned num_sessions;

class PacketHandler_t : public SelectEventHandler {
public:
	int udp_fd, l2tp_fd;

	void SelectEvent(int fd, SelectEventType event);
	virtual void handle_packet(char *buf, unsigned len, struct sockaddr_in *sin)
	{
	}
};

#include "l2tp_peer.h"

class l2tp_tunnel_t;
class l2tp_session_t;

class l2tpd_t : public PacketHandler_t {
	struct sockaddr_in	our_sin;

	l2tp_peer_t		*first_peer;

#define MAX_MULTIHOP_DOMAINS	256
	int			nr_multihop;
	const char		*multihop_domains[MAX_MULTIHOP_DOMAINS];
	l2tp_peer_t		*multihop_peers[MAX_MULTIHOP_DOMAINS];

public:
	l2tp_tunnel_t		*l2tp_tunnels[65536];

	l2tpd_t(struct sockaddr_in);
	l2tp_tunnel_t *make_tunnel(struct sockaddr_in *sin, u16 tunnel);
	void dump_sessions(ctrlfd_t *cfd);
	void dump_num_sessions(ctrlfd_t *cfd);
	void start_tunnel(ctrlfd_t *cfd, const char *ip);
	void start_session(ctrlfd_t *cfd, const char *ip);
	virtual void handle_packet(char *buf, unsigned len, struct sockaddr_in *sin);
	l2tp_peer_t *find_peer(struct sockaddr_in *);
	l2tp_peer_t *find_make_peer(struct sockaddr_in *, char *secret = NULL);

	void dump_multihop(ctrlfd_t *cfd);
	void add_multihop(ctrlfd_t *cfd, const char *ip);
	l2tp_peer_t *lookup_multihop_peer(const char *str);
	l2tp_tunnel_t *try_multihop(OptionSet_t *options);
};

#endif
