/* l2tp_peer.h
 */

class l2tpd_t;
class l2tp_tunnel_t;
class ctrlfd_t;

class l2tp_peer_t : public PacketHandler_t  {
public:
	l2tp_tunnel_t		**l2tp_tunnels;
	l2tpd_t			*l2tpd;
	l2tp_peer_t		*next;

	struct sockaddr_in	local_sin;
	struct sockaddr_in	remote_sin;

	const char		*m_secret;
	int			m_secret_len;

	l2tp_peer_t(l2tpd_t *parent, struct sockaddr_in *local, struct sockaddr_in *remote, const char *secret = NULL);
	void dump_sessions(ctrlfd_t *cfd);
	int alloc_tunnel_id(l2tp_tunnel_t *tunnel);
	void remove_tunnel_id(int id, l2tp_tunnel_t *tunnel);
	void handle_packet(char *buf, unsigned len, struct sockaddr_in *sin);

	l2tp_tunnel_t *make_tunnel(void);
	l2tp_tunnel_t *find_next_tunnel(l2tp_tunnel_t *tunnel);
	l2tp_tunnel_t *find_avail_tunnel(void);
};
