/*
 * kernel.cc - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: kernel.cc,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#include "kernel.h"
#include "debug.h"

void *operator new(size_t size, int priority = GFP_ATOMIC)
{
	void *p;

	DebugEnter("::operator new()");
	switch(priority){
	case GFP_ATOMIC:
		p = kmalloc(size+sizeof(long), GFP_ATOMIC);
		break;
	case GFP_KERNEL:
		p = kmalloc(size+sizeof(long), GFP_KERNEL);
		break;
	default:
		p = NULL;
	}
	if(p) {
		*(long *)p = (long)p;
		p = (long *)p + 1;
		memset(p, 0, size);
	}

	DebugReturn(p);
}

void operator delete(void *t)
{
	DebugEnter("::operator delete()");
	t = (long *)t - 1;
	if (*(long *)t != (long)t) {
		printk("babylon: delete: freeing invalid pointer %p!\n", t);
		return;
	}
	*(long *)t = 0;
	/*memset(t, 0, *(long *)t);*/
	kfree(t);
	DebugVoidReturn;
}
