/*
 * ipcp.h - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: ipcp.h,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef IPCP_H
#define IPCP_H

#include "debug.h"
#include "fsm.h"
#include "protocol.h"
#include "packet.h"

class CInterface;

// Packet Codes

// Option Types
#define IPCP_OPT_ADDRS			1
#define IPCP_OPT_IPCOMPR		2
#define IPCP_OPT_ADDR			3
#define IPCP_OPT_PRIMARY_DNS	129
#define IPCP_OPT_SECOND_DNS		131

// Option Constraints
#define IPCP_OPT_IPCOMPR_VJ	0x002d
#define MIN_VJ_SLOTS            3
#define MAX_VJ_SLOTS		254

// Option Lengths
#define IPCP_HEADER_LENGTH      4
#define IPCP_OPT_ADDR_LEN	6
#define IPCP_OPT_IPCOMPR_LEN	6

class CIpcpProtocol : public CFsmProtocol
{
public:
	CIpcpProtocol();
	~CIpcpProtocol();

public:
	// External Events
	void Input(CPppPacket *);

	CInterface *m_parent;

private:
	OptionSet_t	m_acked;
	OptionSet_t	m_will;

protected:
	virtual void ThisLayerFinished(const char *why);
	virtual void ThisLayerUp();
	virtual void SndConfReq();
	virtual void SndConfAck();
	virtual void SndConfNak();
	virtual void SndTermReq();
	virtual void SndTermAck();
	virtual void SndCodeReject(CPppPacket *);
	virtual void RcvCodeReject(CPppPacket *);

	virtual void RcvConfAck(CPppPacket *);
	virtual void RcvConfRej(CPppPacket *);
	virtual void RcvConfNak(CPppPacket *);
	virtual void RcvConfReq(CPppPacket *);

public:
	void SetWill(OptionSet_t &will) {
		m_will = will;
		m_acked = will;
	}
};

#endif // IPCP_H








