/*
 * iface.h - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: iface.h,v 1.4 2004/08/15 23:22:03 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef IFACE_H
#define IFACE_H

#include "kernel.h"
#include "debug.h"
#include "packet.h"
#ifndef LINK_H
#include "link.h"
#endif
#include "ipcp.h"
//#include "bacp.h"
//#include "bap.h"
#include "queue.h"

#define MAX_SEQNO		0x00FFFFFF
#define MAX_SSEQNO		0x0FFF

#define MP_BEGIN		0x80000000
#define MP_END			0x40000000
#define MP_SBEGIN		0x8000
#define MP_SEND			0x4000

#define MAX_FRAG_BUFS	3

#define IFACE_MAX_DIALS	4

extern char *iface_name(void *, char *);
extern OptionSet_t *get_iface_options(void *);

extern CInterface *FindIfaceDialing(Call *call);
extern void RemoveLinkDialing(Call *call);

class CCheckedIface : public CQueueItem
{
};

class CDeadIface;

class CInterface : public CCheckedIface, public CDebugBase
{
public:
	CInterface(void);
	CInterface(CLink *);
	virtual ~CInterface();

	char		m_name[24];
	CInterface	**m_prevp;
	CInterface	*next;
	CDeadIface	*m_dead;

	virtual void	Close(int cause, const char *reason);
	virtual void	Open();
	virtual void	Down();
	virtual void	Up();
	virtual void	AddLink(CLink *);
	virtual void	DropLink(CLink *link, int cause, const char *reason = NULL);

	void		Ready(OptionSet_t *opts);
	void		KissOfDeath();
	void		RedialTimeout(void);

	int		OutputNoQ(CPppPacket *);
	int		OutputQ(CPppPacket *);
	int		OutputDelete(CPppPacket *);
	void		Input(CPppPacket *);

	friend CInterface	*FindIfaceDialing(Call *call);
	friend void	killIfaces(void);
	friend void	RemoveLinkDialing(Call *call);
	friend void	NetDevDown(void *iface);
	void		do_dial(void);
	friend void	checkCallback(void *data);
	friend void	write_link_state(int fd, CLink *link);
	friend void	CLink::Ready();
	friend void	link_query_dev(int fd, char *name);
	friend void	link_dev_options(int fd, char *name);

private:
	int		ndev_id, ndev_fd;

	CLink		*links;
	int		nr_links;
	int		is_up;
	int		have_ip;
	unsigned long	last_rx_bytes, last_tx_bytes;
	time_t		last_time, last_io_time;

	CTimer		redialTimer;
	int		min_links;		// set to number of links to try to keep up
	int		max_links;
	int		rx_drop_bpls,
			rx_raise_bpls,
			tx_drop_bpls,
			tx_raise_bpls;
	unsigned long	redial_interval;
	long		idle_secs;
	int		links_dialing;		// number of active 'dial' requests
	unsigned	dial_offset;		// offset into number list for next dial attempt
	int		is_static;		// interface is 'static' - up always
	unsigned long	last_dial_jiffies;
	unsigned long	last_io_jiffies;	// last time a packet was sent/received
	int		m_throttled;

	Call		*calls[IFACE_MAX_DIALS];

	OptionSet_t	m_lcfg;
	policy_t	m_rpolicy;		// copy of m_rpolicy from first link in bundle

	CQueue		m_txQueue;

	CIpcpProtocol	m_ipcpProto;
//	CBacpProtocol	m_bacpProto;
//	CBapProtocol	m_bapProto;

	char		*m_phone;
	char		*m_site;
	char		*m_closeReason;
	// This is an ugly workaround for a bug that is not our fault
	int		lflags;			// local Link flags
	int		rflags;			// remote Link flags
	CLink 		*linkFlags;		// Link we need to set flags on

	int ndev_ioctl(unsigned int cmd, unsigned long arg);
};

extern CInterface *ifListHead;

#endif // IFACE_H

