/*
 * fsm.h - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: fsm.h,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef FSM_H
#define FSM_H

#include "config.h"
#include "debug.h"
#include "protocol.h"
#include "packet.h"

enum FsmState {
	ST_INITIAL,
	ST_STARTING,
	ST_CLOSED,
	ST_STOPPED,
	ST_CLOSING,
	ST_STOPPING,
	ST_REQSENT,
	ST_ACKRCVD,
	ST_ACKSENT,
	ST_OPENED
};

// Standard Packet Codes
#define CONFREQ        1
#define CONFACK        2
#define CONFNAK        3
#define CONFREJ        4
#define TERMREQ        5
#define TERMACK        6
#define CODEREJ        7

extern const char *fsmStateName[];

class CFsmProtocol : public CTimedProtocol  
{
public:
	// Construction/Destruction
	CFsmProtocol();
	~CFsmProtocol();

public:
	// Internal FSA counters and timers
	unsigned char cntConfig;
	unsigned char cntTerminate;
	unsigned char cntFailure;

	// Configurables affecting the function of the FSA
	unsigned char maxConfig;
	unsigned char maxTerminate;
	unsigned char maxFailure;
	bool modePassive;
	bool modeRestart;

private:
	// Internal state of the FSA
	enum FsmState state;

public:
	// External Events causing state transition
	virtual void Up();
	virtual void Down();
	virtual void Open();
	virtual void Close(const char *why);
	virtual void TimerExpired();
	virtual void Expire();

protected:
	// Internal Events causing state transition
	// virtual void Timeout();
	// virtual void Expire();
	virtual void RcvGoodConfReq();
	virtual void RcvBadConfReq();
	virtual void RcvConfAck(CPppPacket *pkt = NULL);
	virtual void RcvConfNak(CPppPacket *pkt = NULL);
	virtual void RcvTermReq();
	virtual void RcvTermAck();
	virtual void RcvUnknownCode(CPppPacket *pkt = NULL);
	virtual void RcvCodeReject(CPppPacket *pkt = NULL);
	virtual void RcvFatalReject();
	virtual void RcvEchoReq(CPppPacket *pkt);

	void SetState(enum FsmState ns)
	{
		Log(LF_DEBUG|LF_STATE, "FSA Transition %s -> %s", fsmStateName[state], fsmStateName[ns]);
		state = ns;
	}

protected:
	// Actions to be taken on state transition
	virtual void ThisLayerUp() {};
	virtual void ThisLayerDown() {};
	virtual void ThisLayerStarted() {};
	virtual void ThisLayerFinished(const char *why) {};
	virtual void InitRestartCount() { cntConfig = maxConfig; cntTerminate = maxTerminate; cntFailure = maxFailure; };
	virtual void ZeroRestartCount() { cntConfig = 0; cntTerminate = 0; cntFailure = 0;  };
	virtual void SndConfReq() {};
	virtual void SndConfAck() {};
	virtual void SndConfNak() {};
	virtual void SndTermReq() {};
	virtual void SndTermAck() {};
	virtual void SndCodeReject(CPppPacket *) {};
	virtual void SndEchoReply(CPppPacket *)	{};
};

#endif // FSM_H



