/*
 * debug.h - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: debug.h,v 1.1.1.1 2004/03/11 03:59:31 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef _DEBUG_H_
#define _DEBUG_H_

#include <sys/time.h>
#include <stdio.h>

/*
 * Flags for the type of logging
 */
#define LT_SYSLOG	0x1		// Log messages with syslogd
#define LT_FILE		0x2		// Log messages to a file
#define LT_STDERR	0x4		// Log messages to standard error

/*
 * Bottom 12 bits for the catagory
 * Flags indicating what gets logged
 */
#define LF_NONE		0x0000		// Log Nothing
#define LF_PROTO	0x0001		// Log all Protocol transactions
#define LF_RX		0x0002		// Log all received packets
#define LF_TX		0x0004		// Log all transmitted packets
#define LF_STATE	0x0008		// Log all state transitions
#define LF_PHASE	0x0010		// Log all phase transitions
#define LF_ALLOC	0x0020		// Log and track allocs and frees
#define LF_FUNCS	0x0040		// Log function call flow
#define LF_STATS	0x0080		// Log function call statistics
#define LF_IPC		0x0100		// Log driver-daemon communcations
#define LF_LIST		0x0200		// Log list management functions
#define LF_CALL		0x0400		// Log call control activities
#define LF_CONFIG	0x0800		// Log configuration functions

/*
 * Handy combinations (Not to be used in code, just by the user :)
 */
#define LF_NET		0x0007
#define LF_ALL		0x0FFF

/*
 * The top four bits are for the log verbosity level
 * Works with syslog too
 */
#define LF_DEBUG	0x7000		// Log everything
#define LF_INFO		0x6000		// Log interesting information
#define LF_NOTICE	0x5000		// Log important information
#define LF_WARN		0x4000		// Log warnings
#define LF_ERROR	0x3000		// Log errors
#define LF_CRIT		0x2000		// Log critial problems
#define LF_ALERT	0x1000		// Log alerts
#define LF_EMERG	0x0000		// Log emergency conditions

#define LOGFILENAME			"ppp.log"
#define LOG_BUFFER_SIZE		1024
#define STACK_SIZE			20

#define LT_DFLT		LT_SYSLOG
#define LF_DFLT		LF_INFO
#define SL_DFLT		LOG_LOCAL3	

#define FUNCNAME_LEN            64
struct f_info {
	char name[FUNCNAME_LEN];        // Stack or function names
	struct timeval time_in;         // Time function was entered
};

typedef enum LogState { 
	OPEN, 
	CLOSED 
} LogState_t;                       // States of the logging system
				
struct dbg_info {
	struct f_info f_stack[STACK_SIZE];
	int f_sp;
	char p_name[64];
	char log_file_name[256];
	char log_buffer[LOG_BUFFER_SIZE];
	unsigned short log_flags;
	unsigned char log_facility;
	unsigned char sl_facility;
	LogState_t log_state;
	FILE *log_file_fd;
};

typedef struct dbg_info dbg_info_t;

extern dbg_info_t *dbg_ptr;

class CDebugBase
{
public:
	CDebugBase() { dbg_ptr = ::dbg_ptr; };

	dbg_info_t *dbg_ptr;
};

extern void Log(unsigned short, const char *, ...) __attribute__((format(printf, 2, 3)));
extern void LogPacket(unsigned short fl, unsigned char *buf, int len);
extern int InitLog(char *);
extern void ResetLogFlags(void);
extern void CloseLog(void);
#ifdef DEBUG_TRACE
extern void DebugEnter(char *);
extern void DebugExit(void);
#else
#define DebugEnter(x)	do { (void)(x); } while (0)
#define DebugExit()	do { ; } while (0)
#endif

/*
 * Macros that encapsulate return() and a log savvy
 * variant.
 */
#define DebugReturn(y)		{ \
					DebugExit(); \
					return (y); \
				}

#define DebugVoidReturn		{ \
					DebugExit(); \
					return; \
				}


#endif // _DEBUG_H_
