/*
 * aps_if.h - Device Class Driver Interface Header
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: d_aps_if.h,v 1.1.1.1 2004/03/11 03:59:31 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef _D_APS_IF_H
#define _D_APS_IF_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>

/*
 * Call States
 */
#define CS_IDLE			0
#define CS_DIALING		1
#define CS_RINGING		2
#define CS_CONNECTING		3
#define CS_CONNECTED		4
#define CS_DISCONNECTING	5
#define CS_DISCONNECTED		6
#define CS_STALLED		7
#define CS_UNAVAIL		8

class CLink;

/* 
 * The channel structure 
 * Must be 32-bit aligned!!!!! 
 */
typedef struct channel {
	/* Device Specific */
	unsigned int device_id;
	unsigned int devclass_id;
	char file_name[64];
	char device_name[64];
	char dev_class[64];
	unsigned int unit;

	/* Pointer to associated device */
	void *dev;
  
	/* Outgoing/Incoming dn's */
	char CalledNumber[20];
	char CallerNumber[20];

	/* Link we're attached to */
	CLink *link;

  	/* The current disposition of the channel */
	unsigned char state;
	unsigned char no_auth;		/* set by driver if link is already authenticated. */
	unsigned char tbusy;
	unsigned char reserved;

	unsigned int x_accm[4];		/* Tx Async Control Mask */
	unsigned int r_accm;		/* Rx Async Control Mask */
} channel_t;

/*
 * The following functions are exported from Babylon
 */
extern unsigned int RegisterDeviceClass(char *);
extern void UnregisterDeviceClass(unsigned int);
extern int RegisterChannel(channel_t *);
extern void UnregisterChannel(channel_t *);

#ifdef __cplusplus
};
#endif

#endif // _APS_IF_H

