/*
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: ctrlfd.h,v 1.5 2004/08/28 23:49:40 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */


#ifndef CTRLFD_H
#define CTRLFD_H

#ifndef BABD_H
#include "babd.h"
#endif
#include "selectops.h"
#include <unistd.h>

#include "call.h"

struct sockaddr_in;

class ctrlfd_t : public SelectEventHandler {
public:
	unsigned	c_pos;
	int		c_err;
	char		c_buf[4096];
	Call		*c_call;
	int		c_fd;
	unsigned	c_last_was_nl : 1,
			c_in_init : 1;

	ctrlfd_t	**c_ptr;

	ctrlfd_t(int fd=-1, int in_init=0) {
		c_fd = fd;
		c_pos = 0;
		c_err = 0;
		c_call = 0;
		c_ptr = 0;
		c_last_was_nl = !in_init;
		c_in_init = in_init;
	}

	~ctrlfd_t() {
		if (c_call)
			c_call->cfd = 0;
		c_call = 0;

		if (c_fd >= 0) {
			SelectSetEvents(c_fd, SEL_NONE);
			if (!c_in_init)
				close(c_fd);
		}
		c_fd = -1;
		if (c_ptr)
			*c_ptr = NULL;
	}

	void SelectEvent(int fd, SelectEventType event);
	void printf(const char *fmt, ...) __attribute__((format(printf, 2, 3)));
	void printsin(const struct sockaddr_in *sin);
	void done(int rc);
	void putchar(char ch);

	void unlinkme(ctrlfd_t **ptr) {
		c_ptr = ptr;
	}
};

#endif
