#include "ctrlfd.h"

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <arpa/inet.h>

void ctrlfd_t::printf(const char *fmt, ...)
{
	char buf[1024];
	int len;

	if (c_last_was_nl) {
		strcpy(buf, "[0] 0: ");
		len = 7;
	} else
		len = 0;
	va_list va;
	va_start(va, fmt);
	len += vsnprintf(buf+len, sizeof(buf), fmt, va);
	va_end(va);

	write(c_fd, buf, len);

	c_last_was_nl = (buf[len-1] == '\n');
	if (c_in_init)
		c_last_was_nl = 0;
}

void ctrlfd_t::done(int rc)
{
	char buf[64];
	int len;
	if (!c_last_was_nl)
		write(c_fd, "\n", 1);
	if (!rc)
		rc = -1;
	if (!c_in_init) {
		len = sprintf(buf, "%s[-1] %d:\n", c_last_was_nl ? "" : "\n", rc);
		write(c_fd, buf, len);
	}
	delete this;
}

void ctrlfd_t::printsin(const struct sockaddr_in *sin)
{
	char buf[64];
	int len;
	len = sprintf(buf, "%s%s:%d", c_last_was_nl ? "[0] 0: " : "",
		      inet_ntoa(sin->sin_addr), ntohs(sin->sin_port));
	write(c_fd, buf, len);
	c_last_was_nl = 0;
}

void ctrlfd_t::putchar(char ch)
{
	write(c_fd, &ch, 1);
	c_last_was_nl = (ch == '\n');
	if (c_in_init)
		c_last_was_nl = 0;
}
