/*
 * chap.h - CHAP
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: chap.h,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef CHAP_H
#define CHAP_H

#include "kernel.h"
#include "protocol.h"
#include "packet.h"
#include "config.h"

#define CHAP_HEADER_LENGTH	4

#define CHAP_CODE_CHALLENGE	1
#define CHAP_CODE_RESPONSE	2
#define CHAP_CODE_SUCCESS	3
#define CHAP_CODE_FAILURE	4

#define MAX_USER_LEN		32
#define MAX_SECRET_LEN		32
#define MAX_VALUE_LEN		255	// Max len of challenge
#define MD5_DIGEST_LEN		16

#define CHAP_POLL_TIME		60	// Rechallenge every 60 seconds
#define CHAP_RETRIES		3	// Challenges to resend before giving up

extern void ChapTimeout(unsigned long);
extern void ChapRechallenge(unsigned long);
extern void ChapGotConfig(void *, OptionSet_t *);

class CLink;
 
class CChapProtocol : public CTimedProtocol  
{
public:
	virtual void Down();
	virtual void Up();
	void RcvAuthNak(CPppPacket *);
	void RcvAuthAck(CPppPacket *);
	void RcvAuthChal(CPppPacket *);
	void RcvAuthRsp(CPppPacket *);
	void SndAuthChal();
	void Input(CPppPacket *);
	CChapProtocol();
	virtual ~CChapProtocol();
	friend void ChapTimeout(void *);
	friend void ChapRechallenge(void *);
	friend void ChapGotConfig(void *, OptionSet_t *);

	virtual void TimerExpired();

	CTimer m_pollTimer;

	CLink *m_parent;

protected:
	uint m_restart_count;
};

#endif // CHAP_H
