/*
 * cause.cc
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: cause.cc,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */
 
struct cause {
	unsigned char code;
	char string[64];
};

static struct cause ctbl[] = {
	{ 0x01,	"unassigned number" },
	{ 0x02,	"no route" },
	{ 0x06,	"channel unacceptable" },
	{ 0x10,	"normal clearing" },
	{ 0x11,	"user busy" },
	{ 0x12,	"no user responding" },
	{ 0x15,	"call rejected" },
	{ 0x16,	"number changed" },
	{ 0x1B,	"destination out-of-order" },
	{ 0x1C,	"invalid number format" },
	{ 0x1D,	"facility rejected" },
	{ 0x1E,	"respond to status inquiry" },
	{ 0x1F,	"unspecified cause" },
	{ 0x22,	"no circuit available" },
	{ 0x26,	"network out-of-order" },
	{ 0x29,	"temporary failure" },
	{ 0x2A,	"network congestion" },
	{ 0x2B, "access info discarded" },
	{ 0x2C, "requested channel not available" },
	{ 0x2D,	"pre-empted" },
	{ 0x32,	"requested facility not subscribed" },
	{ 0x34,	"outgoing call barred" },
	{ 0x36,	"incoming call barred" },
	{ 0x3A, "bearer capability not available" },
	{ 0x3F,	"service not available" },
	{ 0x41, "capability not implemented" },
	{ 0x42, "channel not implemented" },
	{ 0x45, "facility not implemented" },
	{ 0x51, "invalid call reference" },
	{ 0x52, "channel does not exist" },
	{ 0x58, "incompatible destination" },
	{ 0x5F, "invalid message unspecified" },
	{ 0x60,	"mandatory information element missing" },
	{ 0x61, "non-existant message" },
	{ 0x62, "wrong message" },
	{ 0x63, "bad information element" },
	{ 0x64, "invalid element contents" },
	{ 0x65, "wrong message for state" },
	{ 0x66, "timer expired" },
	{ 0x67, "mandatory information element length error" },
	{ 0x6F, "protocol error" },
	{ 0x7F, "interworking unspecified" },
	{ 0x00, "" }
};

char *strcause(unsigned char code)
{
	int i;

	for(i = 0 ; ctbl[i].code != 0 ; i++) {
		if(code == ctbl[i].code)
			return ctbl[i].string;
	}
	return 0;
}
