/*
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: call.h,v 1.2 2004/07/30 02:47:51 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */


#ifndef CALL_H
#define CALL_H

#include "d_aps_if.h"

class ctrlfd_t;

extern unsigned int callIdent;

class CInterface;

class Call {
public:
	CInterface	*m_iface;
	unsigned int	ident;	/* semi-unique 'handle' for user apps to refer to the call */

	ctrlfd_t	*cfd;
	channel_t	*ch;

	Call(CInterface *iface = NULL) {
		ident = ++callIdent;
		cfd = 0;
		m_iface = iface;
	}
};

class DialResponse_t {
public:
	Call *call;
	int status;
	char msg[64];

	DialResponse_t()
	{
		status = 0;
		msg[0] = 0;
		call = 0;
	}

	DialResponse_t(Call *c)
	{
		status = 0;
		msg[0] = 0;
		call = c;
	}
};

#endif /* ndef CALL_H */

