/*
 * call.cc
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: call.cc,v 1.1.1.1 2004/03/11 03:59:31 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#include <unistd.h>
#include <stdio.h>

#include "debug.h"
#include "config.h"
#include "ctrlfd.h"

unsigned int callIdent;

void DialReport(DialResponse_t *msg)
{
	char buf[16];

	if (!msg->call) {
		Log(LF_DEBUG|LF_CALL, "DialReport: call_ident == NULL from %p", __builtin_return_address(0));
		return;
	}

	if (!msg->call->cfd)
		return;

	sprintf(buf, "[%u] %d: ", msg->call->ident, msg->status);

	/* FIXME! */
	write(msg->call->cfd->c_fd, buf, strlen(buf));
	write(msg->call->cfd->c_fd, msg->msg, strlen(msg->msg));
	write(msg->call->cfd->c_fd, "\n", 1);
}

