/*
 * bap.h - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: bap.h,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef BAP_H
#define BAP_H

#include "kernel.h"
#include "protocol.h"
#include "packet.h"
#include "../config.h"

#define BAP_HEADER_LENGTH	4

#define BAP_CODE_CALLREQ	1
#define BAP_CODE_CALLRSP	2
#define BAP_CODE_CBACKREQ	3
#define BAP_CODE_CBACKRSP	4
#define BAP_CODE_DROPREQ	5
#define BAP_CODE_DROPRSP	6
#define BAP_CODE_STATIND	7
#define BAP_CODE_STATRSP	8

#define BAP_RSP_ACK			0
#define BAP_RSP_NAK			1
#define BAP_RSP_REJ			2
#define BAP_RSP_FNAK		3

#define BAP_OPT_LINKTYPE	1
#define BAP_OPT_PHDELTA		2
#define BAP_OPT_NOPHONE		3
#define BAP_OPT_REASON		4
#define BAP_OPT_LDISC		5
#define BAP_OPT_CALLSTAT	6

#define BAP_LTYPE_ISDN		1
#define BAP_LTYPE_X25		2
#define BAP_LTYPE_ANALOG	3
#define BAP_LTYPE_SWDIGIT	4
#define BAP_LTYPE_ISDNVOX	5

#define BAP_PDELTA_UNIQUE	1
#define BAP_PDELTA_SUBNUM	2
#define BAP_PDELTA_SUBADDR	3

class CInterface;

class CBapProtocol : public CTimedProtocol  
{
public:
	CBapProtocol();
	virtual ~CBapProtocol();

	virtual void Down();
	virtual void Up();
	void RcvCallReq(CPppPacket *);
	void RcvCBackReq(CPppPacket *);
	void RcvDropReq(CPppPacket *);
	void RcvStatInd(CPppPacket *);
	void SndCallReq();
	void SndCBackReq();
	void SndDropReq();
	void SndStatInd();
	void RcvCallRsp(CPppPacket *);
	void RcvCBackRsp(CPppPacket *);
	void RcvDropRsp(CPppPacket *);
	void RcvStatRsp(CPppPacket *);
	virtual void Input(CPppPacket *);

	virtual void TimerExpired();

	CInterface *m_parent;

protected:
	uint m_restart_count;
};

#endif // BAP_H
