/*
 * bap.cc - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: bap.cc,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#include "kernel.h"
#include "debug.h"
#include "bap.h"
#include "iface.h"

CBapProtocol::CBapProtocol() : CTimedProtocol()
{
	DebugEnter("CBapProtocol::CBapProtocol()");
	DebugVoidReturn;
}

CBapProtocol::~CBapProtocol()
{
	DebugEnter("CBapProtocol::~CBapProtocol()");
	DebugVoidReturn;
}

//
//
//
void CBapProtocol::Input(CPppPacket *packet)
{
	u8 code = packet->Pull8();
	u8 ident = packet->Pull8();
	u16 len = packet->Pull16();

	DebugEnter("CBapProtocol::Input()");

	// Process the packet
	switch(code) {
		case BAP_CODE_CALLREQ:
			m_lastRcvdIdent = ident;
			RcvCallReq(packet);
			break;

		case BAP_CODE_CBACKREQ:
			m_lastRcvdIdent = ident;
			RcvCBackReq(packet);
			break;

		case BAP_CODE_DROPREQ:
			m_lastRcvdIdent = ident;
			RcvDropReq(packet);
			break;

		case BAP_CODE_STATIND:
			m_lastRcvdIdent = ident;
			RcvStatInd(packet);
			break;

		case BAP_CODE_CALLRSP:
			m_lastRcvdIdent = ident;
			RcvCallRsp(packet);
			break;

		case BAP_CODE_CBACKRSP:
			m_lastRcvdIdent = ident;
			RcvCBackRsp(packet);
			break;

		case BAP_CODE_DROPRSP:
			m_lastRcvdIdent = ident;
			RcvDropRsp(packet);
			break;

		case BAP_CODE_STATRSP:
			m_lastRcvdIdent = ident;
			RcvStatRsp(packet);
			break;
	}

	DebugVoidReturn;
}

//
//
//
void CBapProtocol::RcvCallReq(CPppPacket *packet)
{
	DebugEnter("CBapProtocol::RcvCallReq()");
	DebugVoidReturn;
}

//
//
//
void CBapProtocol::RcvCBackReq(CPppPacket *packet)
{
	DebugEnter("CBapProtocol::RcvCBackReq()");
	DebugVoidReturn;
}

//
//
//
void CBapProtocol::RcvDropReq(CPppPacket *packet)
{
	DebugEnter("CBapProtocol::RcvDropReq()");
	DebugVoidReturn;
}

//
//
//
void CBapProtocol::RcvCallRsp(CPppPacket *packet)
{
	DebugEnter("CBapProtocol::RcvCallRsp()");
	DebugVoidReturn;
}

//
//
//
void CBapProtocol::RcvCBackRsp(CPppPacket *packet)
{
	DebugEnter("CBapProtocol::RcvCBackRsp()");
	DebugVoidReturn;
}

//
//
//
void CBapProtocol::RcvDropRsp(CPppPacket *packet)
{
	DebugEnter("CBapProtocol::RcvDropRsp()");
	DebugVoidReturn;
}

//
//
//
void CBapProtocol::RcvStatInd(CPppPacket *packet)
{
	DebugEnter("CBapProtocol::RcvStatInd()");
	DebugVoidReturn;
}

//
//
//
void CBapProtocol::RcvStatRsp(CPppPacket *packet)
{
	DebugEnter("CBapProtocol::RcvStatRsp()");
	DebugVoidReturn;
}

//
//
//
void CBapProtocol::TimerExpired()
{
	DebugEnter("CBapProtocol::TimerExpired()");
	DebugVoidReturn;
}

//
//
//
void CBapProtocol::Up()
{
	DebugEnter("CBapProtocol::Up()");
	DebugVoidReturn;
}

//
//
//
void CBapProtocol::Down()
{
	DebugEnter("CBapProtocol::Down()");
	DebugVoidReturn;
}
