/*
 * bacp.h - Self explanitory
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: bacp.h,v 1.1.1.1 1999/12/30 15:59:24 mark Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */

#ifndef BACP_H
#define BACP_H

#include "debug.h"
#include "fsm.h"
#include "protocol.h"
#include "packet.h"

class CInterface;

// Packet Codes

// Option Types
#define BACP_OPT_FPEER			1

// Option Lengths
#define BACP_HEADER_LENGTH      4
#define BACP_OPT_FPEER_LEN		6

class CBacpProtocol : public CFsmProtocol
{
public:
	CBacpProtocol();
	~CBacpProtocol();

public:
	// External Events
	void Input(CPppPacket *);

	CInterface *m_parent;

protected:
	virtual void ThisLayerUp();
	virtual void ThisLayerDown();
	virtual void SndConfReq();
	virtual void SndTermReq();
	virtual void SndTermAck();
	void SndCodeReject(CPppPacket *);
	void RcvCodeReject(CPppPacket *);

	virtual void RcvConfAck(CPppPacket *);
	virtual void RcvConfRej(CPppPacket *);
	virtual void RcvConfNak(CPppPacket *);
	virtual void RcvConfReq(CPppPacket *);
};

#endif // BACP_H








