/*
 * bab.h
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: bab.h,v 1.1.1.1 2004/03/11 03:59:31 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */


struct bundle;

struct chan {
	channel_t		*ch;
	struct bundle		*bundle;
	struct bundle		*allocd_bundle;

	struct chan		*next;	/* next channel in bundle */

	struct sk_buff_head	tx_q;
	struct sk_buff_head	rx_q;
	int			tx_reserved;

	wait_queue_head_t	tx_wait;
	wait_queue_head_t	rx_wait;
	wait_queue_head_t	wait;
	int			user_active;
	int			user_status;
	int			use_count;
	unsigned		user_calltypes;
	int			dialing;

	int			lflags;
	int			rflags;
	unsigned int		callid;

	int			idx;
	int			m_valid;
	u32			m_seq;
};

#define FRAG_HASH_SIZE	(1 << 4)		/* size of fragment hash bucket -- must be a power of 2 */
#define FRAG_HASH_MASK	(FRAG_HASH_SIZE - 1)

struct bundle {
	struct net_device	dev;
	unsigned		use;

	struct sk_buff		*frag_skb;
	unsigned		frag_offset, frag_num, frag_split;
	u32			frag_seq;

	unsigned long		tx_bytes, rx_bytes;	/* needed under 2.0 for Bandwidth on demand */

	int			index;
	unsigned		num_chan;
	struct chan		*chan;		/* pointer to current channel to transmit to in bundle */

	struct sk_buff_head	tx_q;
	wait_queue_head_t	tx_wait;
	struct sk_buff		*tx_skb;

	struct net_device_stats	stats;

	int			lflags;
	int			rflags;
	u32			m_seq;
	u32			dummy_seq;

	char			name[8];

	int			num_frags;
	struct sk_buff		*frags[FRAG_HASH_SIZE];

	struct slcompress	*slhc;
};

