/* Compatibility Linux-2.0.X <-> Linux-2.1.X
 * Copyright (C) 1997-2000 SpellCaster Telecommunications Inc.
 * $Id: vercomp.h,v 1.3 2004/08/24 01:46:14 bcrl Exp $
 * Released under the GNU Public License. See LICENSE file for details.
 */
#ifndef VERCOMP_H
#define VERCOMP_H

#include <linux/types.h>

#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0))
#define __user	/**/
#endif

#if (LINUX_VERSION_CODE < 0x02030e)
#define net_device	device
#endif

#if (LINUX_VERSION_CODE < 0x020100)
#include <linux/mm.h>
#include <linux/netdevice.h>

static inline unsigned long copy_from_user(void *to, const void *from, unsigned long n)
{
	int i;
	if ((i = verify_area(VERIFY_READ, from, n)) != 0)
		return i;
	memcpy_fromfs(to, from, n);
	return 0;
}

static inline unsigned long copy_to_user(void *to, const void *from, unsigned long n)
{
	int i;
	if ((i = verify_area(VERIFY_WRITE, to, n)) != 0)
		return i;
	memcpy_tofs(to, from, n);
	return 0;
}

static inline void dev_init_buffers(struct net_device *dev)
{
	int i;
	for (i=0; i<DEV_NUMBUFFS; i++)
		skb_queue_head_init(&dev->buffs[i]);
}

#define ioremap(x,y)		vremap(x,y)
#define iounmap(x)		vfree(x)
#define signal_pending(task)	!!((task)->signal & ~(task)->blocked)
#define proc_register(a,b)	proc_register_dynamic(a,b)
#define b_dev_kfree_skb(skb)	dev_kfree_skb(skb,FREE_WRITE)
#define b_dev_kfree_skb_irq(skb)	b_dev_kfree_skb(skb,FREE_WRITE)
#define b_kfree_skb(skb)	kfree_skb(skb,FREE_READ)
#define net_device_stats	enet_statistics
#define b_dev_queue_xmit(skb)	dev_queue_xmit(skb, skb->dev, 0)	

#elif (LINUX_VERSION_CODE >= 0x020100 && LINUX_VERSION_CODE < 0x02032B)
#include <asm/uaccess.h>

#define b_kfree_skb(skb)	kfree_skb(skb)
#define b_dev_kfree_skb(skb)	dev_kfree_skb(skb)
#define b_dev_kfree_skb_irq(skb)	b_dev_kfree_skb(skb)
#define b_dev_queue_xmit(skb)	dev_queue_xmit(skb)

#else
#include <asm/uaccess.h>

#define b_kfree_skb(skb)	kfree_skb(skb)
#define b_dev_kfree_skb(skb)	dev_kfree_skb(skb)
#define b_dev_kfree_skb_irq(skb)	dev_kfree_skb_irq(skb)
#define b_dev_queue_xmit(skb)	dev_queue_xmit(skb)
#endif

#if (LINUX_VERSION_CODE < 0x020125)
#define test_and_clear_bit clear_bit
#define test_and_set_bit set_bit
#endif

#if (LINUX_VERSION_CODE < 0x020212)
struct wait_queue;
typedef struct wait_queue *wait_queue_head_t;
#define DECLARE_WAITQUEUE(wait, task) struct wait_queue wait = { task, NULL }
extern inline void init_waitqueue_head(wait_queue_head_t *w)
{
	*w = NULL;
}



#endif


#if (LINUX_VERSION_CODE < 0x2030f)
#define dev_get_by_name(foo)	dev_get(foo)
#define dev_put(x)		((void)(x))
#endif

#ifndef MODULE_LICENSE
#define MODULE_LICENSE(x)	/**/
#endif

#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,6,0))
#undef MOD_INC_USE_COUNT
#undef MOD_DEC_USE_COUNT

#define MOD_INC_USE_COUNT	(void)0
#define MOD_DEC_USE_COUNT	(void)0
#define dev_init_buffers(x)	((void)(x))
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0))
#define my_sk_alloc(a,b,c,d)	sk_alloc(a,b,c)
#define sk_user_data	user_data
#define sk_data_ready	data_ready
#define sk_rcvbuf	rcvbuf
#define sk_sndbuf	sndbuf
#define sk_sport	sport
#define sk_dport	dport
#define sk_protinfo	protinfo.destruct_hook
enum sock_flags {
        SOCK_DEAD,
        SOCK_DONE,
        SOCK_URGINLINE,
        SOCK_KEEPOPEN,
        SOCK_LINGER,
        SOCK_DESTROY,
        SOCK_BROADCAST,
        SOCK_TIMESTAMP,
};

static inline void sock_set_flag(struct sock *sk, enum sock_flags flag)
{
	if (flag == SOCK_DEAD)
		sk->dead = 1;
	else
		BUG();
}

static inline void sock_reset_flag(struct sock *sk, enum sock_flags flag)
{
	if (flag == SOCK_DEAD)
		sk->dead = 0;
	else
		BUG();
}

static inline int sock_flag(struct sock *sk, enum sock_flags flag)
{
	if (flag == SOCK_DEAD)
		return sk->dead;
	BUG();
	return 0;
}


#else
#define my_sk_alloc(a,b,c,d)	sk_alloc(a,b,c)
#endif

#endif	/* ifndef VERCOMP_H */
