#include <stdio.h>
#include <ctype.h>

void pretty_dump(int len, const unsigned char *buf)
{
	int i;

	fprintf(stderr, "length: %d", len);

	for (i=0; i<len; i++) {
		if (!(i & 15)) {
			fprintf(stderr, "    ");
			if (i > 0) {
				int j;
				const unsigned char *ch = buf+i-16;
				for (j=0; j<16 && (i+j-16) < len; j++, ch++)
					fputc(isprint(*ch) ? *ch : '.', stderr); 
			}
			printf("\n");
		}
		fprintf(stderr, " %02x", buf[i]);
	}
	while (i & 15) {
			i++;
		fprintf(stderr, "   ");
	}

	fprintf(stderr, "    ");
	if (i > 0) {
		int j;
		const unsigned char *ch = buf+i-16;
		for (j=0; j<16 && (i+j-16) < len; j++, ch++)
			fputc(isprint(*ch) ? *ch : '.', stderr); 
	}
	fprintf(stderr, "\n");
}

