#ifndef L2TP_LINUX_H
#define L2TP_LINUX_H

#include <asm/types.h>
#include <linux/socket.h>

#define AF_L2TP		27		/* FIXME: register with kernel */
#define PF_L2TP		AF_L2TP

struct sockaddr_l2tp {
	sa_family_t	sl_family;
	int		sl_rx_sfd;	/* fd of socket to tunnel over */
	int		sl_tx_sfd;	/* fd for tunnel to transmit over */
	__u16		sl_tunnel;
	__u16		sl_session;
	__u16		sl_peer_tunnel;
	__u16		sl_peer_session;
};

struct l2tp_join_bundle {
	__u16		tunnel, session;
	__u16		peer_tunnel, peer_session;
	unsigned long	arg;
};

/* constants for parsing these ugly packets */
#define L2TPF_T		0x8000
#define L2TPF_L		0x4000
#define L2TPF_S		0x0800
#define L2TPF_O		0x0200
#define L2TPF_P		0x0100
#define L2TPF_Ver	0x000f

#define L2TPF_Ver2	0x0002


#define L2TP_AVP_M		0x8000
#define L2TP_AVP_H		0x4000
#define L2TP_AVP_RESERVED	0x3c00
#define L2TP_AVP_LENGTH		0x03ff

#define AVP_MessageType			0
#define AVP_ResultCode			1
#define AVP_ProtocolVersion		2
#define AVP_FramingCapabilities		3
#define AVP_BearerCapabilities		4
#define AVP_TieBreaker			5
#define AVP_FirmwareRevision		6
#define AVP_HostName			7
#define AVP_VendorName			8
#define AVP_AssignedTunnelID		9
#define AVP_ReceiveWindowSize		10
#define AVP_Challenge			11
#define AVP_CauseCode			12
#define AVP_ChallengeResponse		13
#define AVP_AssignedSessionID		14
#define AVP_CallSerialNumber		15
#define AVP_MinimumBPS			16
#define AVP_MaximumBPS			17
#define AVP_BearerType			18
#define AVP_FramingType			19
#define AVP_Reserved20			20
#define AVP_CalledNumber		21
#define AVP_CallingNumber		22
#define AVP_SubAddress			23
#define AVP_ConnectSpeed		24
#define AVP_PhysicalChannelID		25
#define AVP_InitialReceivedLCPConfReq	26
#define AVP_LastSentLCPConfReq		27
#define AVP_LastReceivedLCPConfReq	28
#define AVP_ProxyAuthenType		29
#define AVP_ProxyAuthenName		30
#define AVP_ProxyAuthenChallenge	31
#define AVP_ProxyAuthenID		32
#define AVP_ProxyAuthenResponse		33
#define AVP_CallErrors			34	/* mandatory?  wtf? */
#define AVP_ACCM			35
#define AVP_RandomVector		36
#define AVP_PrivateGroupID		37
#define AVP_RxConnectSpeed		38
#define AVP_SequencingRequired		39

#define L2TP_CMSG_TYPE_SCCRQ		1
#define L2TP_CMSG_TYPE_SCCRP		2
#define L2TP_CMSG_TYPE_SCCCN		3
#define L2TP_CMSG_TYPE_StopCCN		4
#define L2TP_CMSG_TYPE_HELLO		6
#define L2TP_CMSG_TYPE_OCRQ		7
#define L2TP_CMSG_TYPE_OCRP		8
#define L2TP_CMSG_TYPE_OCCN		9
#define L2TP_CMSG_TYPE_ICRQ		10
#define L2TP_CMSG_TYPE_ICRP		11
#define L2TP_CMSG_TYPE_ICCN		12
#define L2TP_CMSG_TYPE_CDN		14
#define L2TP_CMSG_TYPE_WEN		15
#define L2TP_CMSG_TYPE_SLI		16

#endif
