/* l2tp/test_000.c
	- test if an l2tp socket can be created and then bound to a udp
	socket
*/
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "pretty_dump.h"

#include "l2tp_linux.h"

void err(const char *msg)
{
	int no = errno;
	printf("%s: %s (%d)\n", msg, strerror(no), no);
	exit(1);
}

int main(void)
{
	char buf[10240];
	int len;
	int l2tp_fd;
	struct sockaddr_l2tp l2tp_sa;
	int udp_fd;
	struct sockaddr_in sin = {
		sin_family: AF_INET,
		sin_port: htons(1701),
		sin_addr: { htonl(INADDR_ANY) }
	};

	udp_fd = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if (-1 == udp_fd)
		err("socket -- udp");
	if (bind(udp_fd, (struct sockaddr *)&sin, sizeof(sin)))
		err("bind -- udp");

	l2tp_fd = socket(PF_L2TP, SOCK_DGRAM, 0);
	if (-1 == l2tp_fd)
		err("socket -- l2tp");

	l2tp_sa.sl_family = AF_L2TP;
	l2tp_sa.sl_sfd = udp_fd;
	l2tp_sa.sl_tunnel = htons(1);
	l2tp_sa.sl_session = htons(0);

	if (bind(l2tp_fd, (struct sockaddr *)&l2tp_sa, sizeof(l2tp_sa)))
		err("bind -- l2tp");

	if (!bind(l2tp_fd, (struct sockaddr *)&l2tp_sa, sizeof(l2tp_sa))
	   || errno != EBUSY)
		err("bind check for EBUSY -- l2tp");

	printf("waiting for packet\n");
	len = recv(l2tp_fd, buf, sizeof buf, 0);
	fprintf(stderr, "recv() = %d\n", len);
	if (len > 0) {
		pretty_dump(len, buf);
	}

	printf("waiting for keypress\n");
	getchar();
	close(l2tp_fd);

	printf("all passed.\n");

	return 0;
}
